# 🏦 SIMULADOR BANESCO

## 📁 Estructura del Simulador

Este directorio contiene todos los archivos del simulador de API de Banesco, separado del proyecto Python principal para mejor organización.

### 📦 Archivos Incluidos

- **`banesco_simulator.php`** - Servidor PHP principal que simula las respuestas de Banesco
- **`simulator_config.php`** - Archivo de configuración (EDITA ESTE ARCHIVO)
- **`test_simulator.php`** - Script para verificar que el simulador funciona
- **`README_SIMULADOR.md`** - Documentación completa del simulador
- **`SIMULADOR_RESUMEN.md`** - Guía de inicio rápido

## 🚀 Inicio Rápido

### Desde el Directorio Principal

```bash
# Cambiar configuración
change_config.bat

# Iniciar simulador
start_simulator.bat

# Probar con el bot
python main_testserver.py
```

### Desde Este Directorio

```bash
# Iniciar servidor directamente
php -S localhost:8080 banesco_simulator.php

# Verificar funcionamiento
php test_simulator.php
```

## ⚙️ Configuración

Edita `simulator_config.php` para cambiar:

```php
$RESPONSE_TYPE = 'tasas_detected';  // Tipo de respuesta
$SIMULATE_DELAY = true;             // Simular delay de red
$DEBUG_MODE = true;                 // Logs detallados
$RANDOM_RESPONSE = false;           // Respuestas aleatorias
```

## 🎯 Tipos de Respuesta

- **`tasas_detected`** ⭐ - Página de confirmación de tasas (activa efectos visuales)
- **`form_success`** - Formulario de menudeo exitoso (Paso 2)
- **`error_session`** - Error de sesión inválida
- **`error_menudeo_closed`** - Menudeo cerrado/no disponible
- **`error_generic`** - Error genérico del servidor
- **`success_completed`** - Compra completada exitosamente

## 📋 Configuración del Bot

Asegúrate de que `main_testserver.py` apunte al simulador:

```python
base_url = "http://localhost:8080"
```

## 🔍 Testing

1. **Verificar simulador:**
   ```bash
   php test_simulator.php
   ```

2. **Probar efectos visuales:**
   - Configurar `$RESPONSE_TYPE = 'tasas_detected'`
   - Ejecutar `python main_testserver.py`
   - Verificar ventana dorada y efectos

3. **Probar errores:**
   - Configurar tipos de error
   - Verificar manejo en el bot

## 📊 Logs y Monitoreo

- **Logs del simulador:** Consola donde se ejecuta PHP
- **Logs del bot:** Salida de `main_testserver.py`
- **Debug mode:** Activa logs detallados en `simulator_config.php`

## 🛠️ Troubleshooting

### Problema: No se encuentra el simulador
**Solución:** Verificar que estés en el directorio correcto y que los archivos existan.

### Problema: Bot no detecta tasas
**Solución:** 
1. Verificar `$RESPONSE_TYPE = 'tasas_detected'`
2. Verificar que el bot use `http://localhost:8080`
3. Verificar logs del simulador

### Problema: Efectos visuales no funcionan
**Solución:**
1. Usar `main_testserver.py` (no `main.py`)
2. Verificar logs "TASAS DETECTADAS"
3. Verificar función `activate_visual_alert`

## 📁 Organización

Esta carpeta mantiene el simulador separado del proyecto Python principal:

```
superbot/
├── banesco_simulator/          # 📁 Simulador PHP (este directorio)
│   ├── banesco_simulator.php
│   ├── simulator_config.php
│   ├── test_simulator.php
│   └── README.md
├── main_testserver.py          # 🐍 Bot Python
├── start_simulator.bat         # 🚀 Scripts de utilidad
└── change_config.bat
```

¡El simulador está listo para usar! 🎉