# 🏦 SIMULADOR DE API BANESCO

## 📋 Descripción

Este simulador PHP permite probar el flujo completo del bot de menudeo sin necesidad de conectarse al servidor real de Banesco. Simula las respuestas de los pasos 2 y 3 del flujo de compra de divisas.

## 📁 Archivos del Simulador

- **`banesco_simulator.php`** - Servidor principal que procesa las peticiones
- **`simulator_config.php`** - Archivo de configuración (EDITA ESTE ARCHIVO)
- **`README_SIMULADOR.md`** - Este archivo de documentación

## 🚀 Instalación y Configuración

### 1. Requisitos
- PHP 7.4 o superior
- Servidor web (Apache, Nginx, o PHP built-in server)

### 2. Configuración del Servidor Web

#### Opción A: Servidor PHP integrado (Recomendado para testing)
```bash
php -S localhost:8080 banesco_simulator.php
```

#### Opción B: Apache/Nginx
Configura el servidor para que `banesco_simulator.php` maneje todas las peticiones a las rutas:
- `/Menudeo/validarCompra`
- `/Menudeo/MenudeoCompra`

### 3. Configuración del Bot
En `main_testserver.py`, cambia la URL base para apuntar al simulador:
```python
# Cambiar de:
base_url = "https://www.banesco.com"

# A:
base_url = "http://localhost:8080"
```

## ⚙️ Configuración de Respuestas

### Cambiar Tipo de Respuesta

Edita el archivo **`simulator_config.php`** y cambia la variable `$RESPONSE_TYPE`:

```php
// Para simular tasas detectadas (Paso 3)
$RESPONSE_TYPE = 'tasas_detected';

// Para simular formulario exitoso (Paso 2)
$RESPONSE_TYPE = 'form_success';

// Para simular errores
$RESPONSE_TYPE = 'error_session';
$RESPONSE_TYPE = 'error_menudeo_closed';
$RESPONSE_TYPE = 'error_generic';

// Para simular operación completada
$RESPONSE_TYPE = 'success_completed';
```

### Tipos de Respuesta Disponibles

| Tipo | Descripción | Uso |
|------|-------------|-----|
| `tasas_detected` | ⭐ **Página de confirmación de tasas** | Simula el Paso 3 con tasas de cambio |
| `form_success` | Formulario de menudeo exitoso | Simula el Paso 2 con formulario |
| `error_session` | Error de sesión inválida | Simula sesión expirada |
| `error_menudeo_closed` | Menudeo cerrado/no disponible | Simula servicio no disponible |
| `error_generic` | Error genérico del servidor | Simula errores internos |
| `success_completed` | Compra completada exitosamente | Simula operación exitosa |

## 🎯 Escenarios de Prueba

### Escenario 1: Flujo Normal (Recomendado)
```php
$RESPONSE_TYPE = 'tasas_detected';
$SIMULATE_DELAY = true;
$RANDOM_RESPONSE = false;
```
**Resultado:** El bot detectará tasas y activará los efectos visuales.

### Escenario 2: Errores de Sesión
```php
$RESPONSE_TYPE = 'error_session';
$SIMULATE_DELAY = true;
$RANDOM_RESPONSE = false;
```
**Resultado:** El bot detectará error de sesión.

### Escenario 3: Menudeo Cerrado
```php
$RESPONSE_TYPE = 'error_menudeo_closed';
$SIMULATE_DELAY = false;
$RANDOM_RESPONSE = false;
```
**Resultado:** El bot detectará que el menudeo está cerrado.

### Escenario 4: Testing Aleatorio
```php
$RESPONSE_TYPE = 'form_success'; // Ignorado
$SIMULATE_DELAY = true;
$RANDOM_RESPONSE = true;
```
**Resultado:** Respuestas aleatorias para testing extensivo.

## 🔧 Configuración Avanzada

### Personalizar Tasas de Cambio

En `simulator_config.php`:

```php
$TASA_CONFIG = [
    'monto_usd' => 100.00,                    // Monto en dólares
    'tasa_min' => 130.00,                     // Tasa mínima
    'tasa_max' => 140.00,                     // Tasa máxima
    'comision_porcentaje' => 0.002,           // Comisión (0.2%)
    'cuenta_origen' => '0134-****-**-***1234567',
    'cuenta_destino' => 'Cuenta Verde Persona (USD)',
    'destino_fondos' => 'Capital de Trabajo',
    'descripcion' => 'COMPRA DIVISAS'
];
```

### Habilitar/Deshabilitar Delay de Red

```php
$SIMULATE_DELAY = true;   // Simula delay de 1-3 segundos
$SIMULATE_DELAY = false;  // Respuesta inmediata
```

### Modo Debug

```php
$DEBUG_MODE = true;   // Registra información detallada
$DEBUG_MODE = false;  // Funcionamiento silencioso
```

## 📊 Monitoreo y Logs

### Ver Logs en Tiempo Real

**Windows:**
```cmd
Get-Content php_errors.log -Wait -Tail 10
```

**Linux/Mac:**
```bash
tail -f /var/log/php_errors.log
```

### Ejemplo de Log
```
[2025-01-16 10:30:15] [BANESCO_SIMULATOR] === CONFIGURACIÓN CARGADA ===
[2025-01-16 10:30:15] [BANESCO_SIMULATOR] Tipo de respuesta: tasas_detected
[2025-01-16 10:30:15] [BANESCO_SIMULATOR] Simular delay: SÍ
[2025-01-16 10:30:20] [BANESCO_SIMULATOR] Request: POST /Menudeo/validarCompra - Response Type: tasas_detected
[2025-01-16 10:30:20] [BANESCO_SIMULATOR] Generating tasas confirmation response
[2025-01-16 10:30:23] [BANESCO_SIMULATOR] Response sent successfully
```

## 🧪 Testing del Bot

### Flujo de Prueba Completo

1. **Configurar simulador:**
   ```php
   $RESPONSE_TYPE = 'tasas_detected';
   ```

2. **Iniciar simulador:**
   ```bash
   php -S localhost:8080 banesco_simulator.php
   ```

3. **Ejecutar bot:**
   ```bash
   python main_testserver.py
   ```

4. **Verificar efectos visuales:**
   - Cambio de color de ventana
   - Parpadeo de colores
   - Sonidos de alerta
   - Movimiento de ventana
   - Logs especiales

### Verificar Detección de Tasas

El bot debe detectar:
- Texto "Tasa Compra de Divisas"
- Valores numéricos de tasas
- Activación de efectos visuales
- Log: "TASAS DETECTADAS"

## 🔍 Troubleshooting

### Problema: Bot no detecta tasas
**Solución:** Verificar que `$RESPONSE_TYPE = 'tasas_detected'` en `simulator_config.php`

### Problema: Efectos visuales no se activan
**Solución:** Verificar que el bot esté usando `main_testserver.py` y apuntando al simulador

### Problema: Errores de conexión
**Solución:** Verificar que el simulador esté ejecutándose en el puerto correcto

### Problema: Respuestas inesperadas
**Solución:** Revisar logs con `$DEBUG_MODE = true`

## 📝 Notas Importantes

- **No edites `banesco_simulator.php`** - Usa `simulator_config.php` para cambios
- **Guarda `simulator_config.php`** después de cada cambio
- **Reinicia el servidor** si cambias configuraciones avanzadas
- **Usa `tasas_detected`** para probar efectos visuales
- **Habilita logs** para debugging

## 🎉 Ejemplos de Uso Rápido

### Probar Efectos Visuales
```php
// En simulator_config.php
$RESPONSE_TYPE = 'tasas_detected';
$SIMULATE_DELAY = false;  // Respuesta rápida
$DEBUG_MODE = true;
```

### Probar Manejo de Errores
```php
// En simulator_config.php
$RESPONSE_TYPE = 'error_session';
$SIMULATE_DELAY = true;
$DEBUG_MODE = true;
```

### Testing Extensivo
```php
// En simulator_config.php
$RANDOM_RESPONSE = true;  // Respuestas aleatorias
$SIMULATE_DELAY = true;
$DEBUG_MODE = true;
```

---

**¡Listo para probar! 🚀**

Para cambiar el comportamiento, simplemente edita `simulator_config.php` y guarda el archivo. El simulador usará automáticamente la nueva configuración.