# 🏦 SIMULADOR BANESCO - RESUMEN COMPLETO

## 📦 Archivos Creados

### Archivos Principales
- **`banesco_simulator.php`** - Servidor PHP que simula las respuestas de Banesco
- **`simulator_config.php`** - Archivo de configuración (EDITA ESTE ARCHIVO)
- **`README_SIMULADOR.md`** - Documentación completa del simulador

### Scripts de Utilidad
- **`test_simulator.php`** - Script para verificar que el simulador funciona
- **`start_simulator.bat`** - Script para iniciar el simulador fácilmente
- **`change_config.bat`** - Script para cambiar configuración rápidamente
- **`SIMULADOR_RESUMEN.md`** - Este archivo de resumen

## 🚀 Inicio Rápido

### 1. Configurar Respuesta
```bash
# Opción A: Usar script automático
change_config.bat

# Opción B: Editar manualmente
# Edita simulator_config.php y cambia:
$RESPONSE_TYPE = 'tasas_detected';  # Para efectos visuales
```

### 2. Iniciar Simulador
```bash
# Opción A: Usar script automático
start_simulator.bat

# Opción B: Comando manual
php -S localhost:8080 banesco_simulator.php
```

### 3. Configurar Bot
En `main_testserver.py`, asegúrate de que apunte al simulador:
```python
base_url = "http://localhost:8080"
```

### 4. Probar
```bash
python main_testserver.py
```

## 🎯 Escenarios de Prueba

### Para Probar Efectos Visuales (RECOMENDADO)
```php
// En simulator_config.php
$RESPONSE_TYPE = 'tasas_detected';
```
**Resultado:** El bot detectará tasas y activará:
- ✨ Cambio de color de ventana a dorado
- 🌈 Parpadeo de colores
- 🔊 Sonidos de alerta
- 📱 Movimiento de ventana
- 📝 Logs especiales

### Para Probar Manejo de Errores
```php
// En simulator_config.php
$RESPONSE_TYPE = 'error_session';        // Error de sesión
$RESPONSE_TYPE = 'error_menudeo_closed'; // Menudeo cerrado
$RESPONSE_TYPE = 'error_generic';        // Error genérico
```

### Para Probar Flujo Completo
```php
// En simulator_config.php
$RESPONSE_TYPE = 'form_success';      // Paso 2: Formulario
$RESPONSE_TYPE = 'success_completed'; // Operación exitosa
```

### Para Testing Extensivo
```php
// En simulator_config.php
$RANDOM_RESPONSE = true; // Respuestas aleatorias
```

## 📋 Tipos de Respuesta Disponibles

| Tipo | Descripción | Cuándo Usar |
|------|-------------|-------------|
| `tasas_detected` | ⭐ Página de confirmación de tasas | **Para activar efectos visuales** |
| `form_success` | Formulario de menudeo exitoso | Para probar Paso 2 del flujo |
| `error_session` | Error de sesión inválida | Para probar manejo de errores |
| `error_menudeo_closed` | Menudeo cerrado/no disponible | Para probar detección de cierre |
| `error_generic` | Error genérico del servidor | Para probar errores generales |
| `success_completed` | Compra completada exitosamente | Para probar flujo exitoso |

## ⚙️ Configuración Personalizada

### Personalizar Tasas de Cambio
```php
// En simulator_config.php
$TASA_CONFIG = [
    'monto_usd' => 100.00,           // Monto en dólares
    'tasa_min' => 130.00,            // Tasa mínima
    'tasa_max' => 140.00,            // Tasa máxima
    'comision_porcentaje' => 0.002,  // Comisión (0.2%)
    'cuenta_origen' => '0134-****-**-***1234567',
    'cuenta_destino' => 'Cuenta Verde Persona (USD)',
    'destino_fondos' => 'Capital de Trabajo',
    'descripcion' => 'COMPRA DIVISAS'
];
```

### Otras Configuraciones
```php
// En simulator_config.php
$SIMULATE_DELAY = true;   // Simular delay de red (1-3 seg)
$DEBUG_MODE = true;       // Mostrar logs detallados
$RANDOM_RESPONSE = false; // Respuesta fija vs aleatoria
```

## 🔍 Verificación y Testing

### Verificar Configuración
```bash
php test_simulator.php
```

### Ver Logs en Tiempo Real
```bash
# Windows PowerShell
Get-Content php_errors.log -Wait -Tail 10

# CMD
tail -f php_errors.log
```

### Verificar que el Bot Detecta Tasas
Busca en los logs del bot:
```
[INFO] TASAS DETECTADAS - Activando efectos visuales
[INFO] Activando alerta visual llamativa
[SUCCESS] Efectos visuales activados correctamente
```

## 🎨 Efectos Visuales Implementados

Cuando el bot detecta tasas (`tasas_detected`), se activan:

### En la Aplicación de Escritorio
- 🟡 **Cambio de color:** Ventana se vuelve dorada
- 🌈 **Parpadeo:** Ciclo de colores llamativos
- 📝 **Título dinámico:** "¡TASAS DETECTADAS!"
- 🔊 **Sonidos:** Alertas audibles (Windows)
- 📱 **Movimiento:** Ventana se mueve ligeramente
- 📋 **Logs especiales:** Mensajes destacados

### En la Interfaz Web
- 🚨 **Overlay:** Alerta de pantalla completa
- ✨ **Animaciones:** Efectos CSS llamativos
- 🔊 **Sonidos web:** Alertas de navegador
- 🎯 **Auto-desactivación:** Se quita automáticamente

## 🛠️ Troubleshooting

### Problema: Bot no detecta tasas
**Solución:**
1. Verificar que `$RESPONSE_TYPE = 'tasas_detected'` en `simulator_config.php`
2. Verificar que el bot use `http://localhost:8080`
3. Verificar que el simulador esté ejecutándose

### Problema: Efectos visuales no se activan
**Solución:**
1. Verificar que uses `main_testserver.py` (no `main.py`)
2. Verificar logs del bot para "TASAS DETECTADAS"
3. Verificar que la función `activate_visual_alert` esté en el código

### Problema: Errores de conexión
**Solución:**
1. Verificar que PHP esté instalado: `php --version`
2. Verificar que el puerto 8080 esté libre
3. Usar `start_simulator.bat` para inicio automático

### Problema: Configuración no se aplica
**Solución:**
1. Guardar `simulator_config.php` después de editar
2. Reiniciar el simulador
3. Usar `change_config.bat` para cambios automáticos

## 📊 Flujo de Testing Recomendado

1. **Configurar para tasas:**
   ```bash
   change_config.bat  # Seleccionar opción 1
   ```

2. **Iniciar simulador:**
   ```bash
   start_simulator.bat
   ```

3. **Ejecutar bot:**
   ```bash
   python main_testserver.py
   ```

4. **Verificar efectos:**
   - Ventana dorada ✅
   - Parpadeo de colores ✅
   - Sonidos de alerta ✅
   - Logs "TASAS DETECTADAS" ✅

5. **Probar otros escenarios:**
   - Cambiar configuración con `change_config.bat`
   - Probar errores y flujos alternativos

## 🎉 ¡Todo Listo!

El simulador está completamente configurado y listo para usar. Puedes:

- ✅ **Probar efectos visuales** con `tasas_detected`
- ✅ **Simular errores** con los tipos de error
- ✅ **Testing extensivo** con respuestas aleatorias
- ✅ **Personalizar tasas** editando la configuración
- ✅ **Monitorear en tiempo real** con logs detallados

**¡Disfruta probando el bot sin limitaciones! 🚀**