<?php
/**
 * SIMULADOR DE API BANESCO
 * 
 * Este servidor PHP simula las respuestas de Banesco para probar el flujo completo del bot
 * sin necesidad de conectarse al servidor real.
 * 
 * Endpoints simulados:
 * - POST /Menudeo/validarCompra (Paso 2)
 * - GET /Menudeo/MenudeoCompra (Paso 3)
 * 
 * Autor: Asistente AI
 * Fecha: 2025-01-16
 */

header('Content-Type: text/html; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');

// Manejar preflight OPTIONS
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// =============================================================================
// CARGA DE CONFIGURACIÓN EXTERNA
// =============================================================================

/**
 * CONFIGURACIÓN PRINCIPAL
 * 
 * La configuración se carga desde simulator_config.php
 * Para cambiar el comportamiento del simulador, edita ese archivo.
 * 
 * RESPUESTAS DISPONIBLES:
 * - 'form_success': Formulario de menudeo exitoso (Paso 2)
 * - 'tasas_detected': Página de confirmación de tasas (Paso 3)
 * - 'error_session': Error de sesión inválida
 * - 'error_menudeo_closed': Menudeo cerrado/no disponible
 * - 'error_generic': Error genérico del servidor
 * - 'success_completed': Compra completada exitosamente
 */

// Cargar configuración externa
if (file_exists(__DIR__ . '/simulator_config.php')) {
    require_once __DIR__ . '/simulator_config.php';
    if ($DEBUG_MODE) {
        error_log("[BANESCO_SIMULATOR] Configuración cargada desde simulator_config.php");
    }
} else {
    // Configuración por defecto si no existe el archivo de configuración
    $RESPONSE_TYPE = 'tasas_detected';
    $SIMULATE_DELAY = true;
    $RANDOM_RESPONSE = false;
    $DEBUG_MODE = true;
    $TASA_CONFIG = [
        'monto_usd' => 100.00,
        'tasa_min' => 130.00,
        'tasa_max' => 140.00,
        'comision_porcentaje' => 0.002,
        'cuenta_origen' => '0134-****-**-***1234567',
        'cuenta_destino' => 'Cuenta Verde Persona (USD)',
        'destino_fondos' => 'Capital de Trabajo',
        'descripcion' => 'COMPRA DIVISAS'
    ];
    $CUSTOM_HEADERS = [];
    
    error_log("[BANESCO_SIMULATOR] ADVERTENCIA: simulator_config.php no encontrado, usando configuración por defecto");
}

// =============================================================================
// FUNCIONES DE RESPUESTA
// =============================================================================

/**
 * Genera el formulario de menudeo (Paso 2 - validarCompra exitoso)
 */
function generateMenudeoForm() {
    $timestamp = date('YmdHis');
    $formLoadTime = time() . '0000000';
    
    return '
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" xml:lang="en" lang="en" translate="no" />
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Compra</title>
    <link rel="stylesheet" href="../../Content/Site.min.css" type="text/css" />
    <link rel="stylesheet" href="../../Content/datatables.css?v=2.2.4" type="text/css" />
    <link rel="stylesheet" href="../../Content/buttons.dataTables.css?v=2.0.0" type="text/css" />
    <link rel="stylesheet" href="../../Content/fontawesome/fontawesome-free-5.5.0-web/css/all.css">
    <link rel="stylesheet" href="../../fonts/banesco-iconos latin/StylesheetIcon.css">
    <link rel="stylesheet" href="../../Content/sweetalert2.css?v=2.2.6">
    <link rel="stylesheet" href="../../Content/jquery-ui.css" type="text/css" />
    <link rel="stylesheet" href="../../Content/bootstrap.css?v=2.2.7.2" />
    
    <meta http-equiv="Expires" content="0">
    <meta http-equiv="Last-Modified" content="0">
    <meta http-equiv="Cache-Control" content="no-cache, mustrevalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta name="robots" content="noindex,nofollow" />
    
    <style>
        #myDIV { overflow: auto; }
    </style>
    
    <script type="text/javascript">
        function GoTopPage() {
            var elmnt = document.getElementById("TituloX");
            elmnt.scrollIntoView();
        }
    </script>
</head>
<body onload="GoTopPage()">
    <div id="body">
        <div class="container-fluid" id"mydiv">
            <div class="col-md-12" id="TituloX"></div>
            
<input data-val="true" data-val-number="The field Int64 must be a number." data-val-required="The Int64 field is required." id="FormLoadTime" name="FormLoadTime" type="hidden" value="' . $formLoadTime . '" />
<div id="preloader">
    <img class="blink" src="../../images/logo.png" alt="" />
</div>

<div class="col-md-12">
    <div class="panel panel-default">
        <div class="panel-heading">
            <div class="ConDiv">
                <i class="icon-exclamacion"></i>
            </div>
        </div>
        <div class="panel-body">
            <p>
                Esta opción le permite realizar operaciones de <b>Menudeo</b> de su Cuenta Verde.<br />Para ello, ingrese los datos solicitado y luego haga clic en el botón <b>Continuar</b>.<br />Recuerde verificar que todos los datos estén correctos.
            </p>
            <br />
        </div>
    </div>
</div>

<br />
<div class="col-md-12">
    <table class="table" id="marTabla">
        <thead>
            <tr>
                <th class="col-md-4 "></th>
                <th class="col-md-4 Banesco_header_tb Banesco_th" colspan="3">MENUDEO COMPRAS</th>
                <th class="col-md-4 "></th>
            </tr>
        </thead>
    </table>
    <br />
</div>

<div class="col-md-12">
    <div align="center">
        <form class="form-horizontal" role="form" id="form" action="/Menudeo/validarCompra" method="post" onsubmit="document.getElementById(\'crear\').disabled=true;">
            
            <div class="form-group col-md-12 formStyle">
                <label for="ejemplo_password_3" class="col-md-6 control-label payment_font">Desde mi cuenta en Bs.:</label>
                <div class="col-md-6">
                    <select class="form-control" id="Numcuentabs" name="Numcuentabs" required>
                        <option value="" disabled selected>Seleccione</option>
                        <option value="0134-****-**-***1234567">0134-****-**-***1234567</option>
                    </select>
                    <span id="saldobs" name="saldobs" readonly style="float:left; text-shadow: 0 0 black">Saldo: Bs. 50,000.00</span>
                    <input type="hidden" name="saldos" id="saldoInputbs" />
                    <i id="msmNumcuentabs" style="color:red;"></i>
                </div>
            </div>
            
            <div class="form-group col-md-12 formStyle">
                <label for="ejemplo_password_3" class="col-md-6 control-label payment_font">Hacia mi cuenta Verde:</label>
                <div class="col-md-6">
                    <select class="form-control" id="NumcuentaDol" name="Numcuentadol" required>
                        <option value="" disabled selected>Seleccione</option>
                        <option value="cuenta_verde_usd">Cuenta Verde Persona (USD)</option>
                    </select>
                    <span id="saldoDOl" name="saldoDol" readonly style="float:left; text-shadow: 0 0 black">Saldo: $ 0.00</span>
                    <i id="msmNumcuentaDol" style="color:red;"></i>
                </div>
            </div>
            
            <div class="form-group col-md-12 formStyle">
                <label for="ejemplo_password_3" class="col-md-6 control-label payment_font">Monto:</label>
                <div class="col-md-6">
                    <input type="text" data-thousands="." data-decimal="," class="form-control" name="monto" id="monto" placeholder="Ingrese el monto en divisas" pattern="[0-9,.]{1,21}" maxlength="21" autocomplete="off" value="100,00">
                    <i id="msm" style="color:red;"></i>
                </div>
            </div>
            
            <div class="form-group col-md-12 formStyle">
                <label for="ejemplo_password_3" class="col-md-6 control-label payment_font">Destino de los fondos:</label>
                <div class="col-md-6">
                    <select class="form-control" id="destino" name="destino" required>
                        <option value="" disabled selected>Seleccione</option>
                        <option value="Capital de Trabajo" selected>Capital de Trabajo</option>
                        <option value="Pago de Servicios">Pago de Servicios</option>
                        <option value="Ahorro">Ahorro</option>
                        <option value="Pago de Proveedores">Pago de Proveedores</option>
                    </select>
                    <i id="msmdestino" style="color:red;"></i>
                </div>
            </div>
            
            <div class="form-group col-md-12 formStyle">
                <label for="ejemplo_password_3" class="col-md-6 control-label payment_font">Descripción:</label>
                <div class="col-md-6">
                    <textarea type="text" class="form-control" name="concepto" id="concepto" placeholder="Descripción" pattern="[A-Za-z0-9 ]{3,30}" maxlength="30">COMPRA DIVISAS</textarea>
                    <i id="msmconcepto" style="color:red;"></i>
                </div>
            </div>
            
            <br />
            
            <div class="col-md-12">
                <p align="center" style="font-family: Verdana, Arial, Serif; font-size: 11px;">
                    Recuerde que los montos de esta operación serán <b>procesados en moneda extranjera</b>,<br /> una vez haga clic en el botón <b>Continuar</b> no podrá realizar cambios.<br /><br />
                    <b>¿Está usted seguro de realizar esta operación?</b>
                </p>
            </div>
            
            <div class="col-md-12 ">
                <br />
                <div class="col-md-3"></div>
                <div class="col-md-1">
                    <button type="reset" class="btn btn-primary" id="borrar" data-target="#exampleModal">Borrar</button>
                </div>
                <div class="col-md-3"></div>
                <div class="col-md-1">
                    <button type="submit" class="btn btn-primary" id="crear" data-target="#exampleModal">Continuar</button>
                </div>
                <div class="col-md-3"></div>
            </div>
            
        </form>
    </div>
</div>

        </div>
    </div>
</body>
</html>';
}

/**
 * Genera la página de confirmación de tasas (Paso 3 - MenudeoCompra)
 */
function generateTasasConfirmation() {
    global $TASA_CONFIG;
    
    $timestamp = date('YmdHis');
    $formLoadTime = time() . '0000000';
    
    // Usar configuración de tasas
    $monto = $TASA_CONFIG['monto_usd'];
    $tasa_min = $TASA_CONFIG['tasa_min'] * 100; // Convertir a formato interno
    $tasa_max = $TASA_CONFIG['tasa_max'] * 100;
    $tasa = number_format(rand($tasa_min, $tasa_max) / 100, 8, '.', '');
    $subtotal = $monto * $tasa;
    $comision = $subtotal * $TASA_CONFIG['comision_porcentaje'];
    $total = $subtotal + $comision;
    
    return '
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" xml:lang="en" lang="en" translate="no" />
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Confirmar Operación Compra</title>
    <link rel="stylesheet" href="../../Content/Site.min.css" type="text/css" />
    <link rel="stylesheet" href="../../Content/datatables.css?v=2.2.4" type="text/css" />
    <link rel="stylesheet" href="../../Content/buttons.dataTables.css?v=2.0.0" type="text/css" />
    <link rel="stylesheet" href="../../Content/fontawesome/fontawesome-free-5.5.0-web/css/all.css">
    <link rel="stylesheet" href="../../fonts/banesco-iconos latin/StylesheetIcon.css">
    <link rel="stylesheet" href="../../Content/sweetalert2.css?v=2.2.6">
    <link rel="stylesheet" href="../../Content/jquery-ui.css" type="text/css" />
    <link rel="stylesheet" href="../../Content/bootstrap.css?v=2.2.7.2" />
    
    <meta http-equiv="Expires" content="0"> 
    <meta http-equiv="Last-Modified" content="0">
    <meta http-equiv="Cache-Control" content="no-cache, mustrevalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta name="robots" content="noindex,nofollow" />
    
    <style>
        #myDIV { overflow: auto; }
    </style>
    
    <script type="text/javascript">
        function GoTopPage() {
            var elmnt = document.getElementById("TituloX");
            elmnt.scrollIntoView();
        }
    </script>
</head>
<body onload="GoTopPage()">
    <div id="body">
        <div class="container-fluid" id"mydiv">
            <div class="col-md-12" id="TituloX"></div>
            
<input data-val="true" data-val-number="The field Int64 must be a number." data-val-required="The Int64 field is required." id="FormLoadTime" name="FormLoadTime" type="hidden" value="' . $formLoadTime . '" />
<div id="preloader">
    <img class="blink" src="../../images/logo.png" alt="" />
</div>

<div class="col-md-12">
    <div class="panel panel-default">
        <div class="panel-heading">
            <div class="ConDiv">
                <i class="icon-exclamacion"></i>
            </div>
        </div>
        <div class="panel-body">
            <p>
                Esta opción le permite confirmar que los datos ingresados en cada campo sean los correctos.
                <br />
                En caso contrario presione la opción de <b>Regresar</b> para realizar el cambio necesario.
            </p>
            <br />
        </div>
    </div>
</div>

<div class="col-md-12">
    <table class="table" id="marTabla">
        <thead>
            <tr>
                <th class="col-md-4 "></th>
                <th class="col-md-4 Banesco_header_tb Banesco_th" colspan="3">CONFIRMACIÓN OPERACIONES MENUDEO COMPRAS</th>
                <th class="col-md-4 "></th>
            </tr>
        </thead>
    </table>
    <br />
</div>

<div class="form-group col-md-12 formStyle">
    <div class="col-md-6">
        <p class="payment_font"><strong>Desde mi cuenta en Bs.:</strong></p>
    </div>
    <div class="col-md-6">
        <p class="payment_font">' . $TASA_CONFIG['cuenta_origen'] . '</p>
    </div>
</div>

<div class="form-group col-md-12 formStyle">
    <div class="col-md-6">
        <p class="payment_font"><strong>Hacia mi cuenta Verde:</strong></p>
    </div>
    <div class="col-md-6">
        <p class="payment_font">' . $TASA_CONFIG['cuenta_destino'] . '</p>
    </div>
</div>

<div class="form-group col-md-12 formStyle">
    <div class="col-md-6">
        <p class="payment_font"><strong>Monto en divisas: </strong></p>
    </div>
    <div class="col-md-6">
        <p class="payment_font">$ ' . number_format($monto, 2) . '</p>
    </div>
</div>

<div class="form-group col-md-12 formStyle">
    <div class="col-md-6">
        <p class="payment_font"><strong>Tasa Compra de Divisas:</strong></p>
    </div>
    <div class="col-md-6">
        <p class="payment_font">USD($) 1,00 = VES (Bs.) ' . $tasa . '</p>
    </div>
</div>

<div class="form-group col-md-12 formStyle">
    <div class="col-md-6">
        <p><strong>Sub total de la Operación Cambiaria:</strong></p>
    </div>
    <div class="col-md-6">
        <p>Bs. ' . number_format($subtotal, 2) . '</p>
    </div>
</div>

<div class="form-group col-md-12 formStyle">
    <div class="col-md-6">
        <p><strong>Comisión de la Operación: </strong></p>
    </div>
    <div class="col-md-6">
        <p>0,2% (Bs. ' . number_format($comision, 8) . ')</p>
    </div>
</div>

<div class="form-group col-md-12 formStyle">
    <div class="col-md-6">
        <p><strong>Monto neto a debitar en cuenta del cliente:</strong></p>
    </div>
    <div class="col-md-6">
        <p>Bs. ' . number_format($total, 2) . '</p>
    </div>
</div>

<div class="form-group col-md-12 formStyle">
    <div class="col-md-6">
        <p><strong>Destino de los Fondos:</strong></p>
    </div>
    <div class="col-md-6">
        <p>' . $TASA_CONFIG['destino_fondos'] . '</p>
    </div>
</div>

<div class="form-group col-md-12 formStyle">
    <div class="col-md-6">
        <p><strong>Descripción:</strong></p>
    </div>
    <div class="col-md-6">
        <p>' . $TASA_CONFIG['descripcion'] . '</p>
    </div>
</div>

<div class="col-md-12">
    <p align="center" style="font-family: Verdana, Arial, Serif; font-size: 11px;">
        <b>
            Una vez que presione "Confirmar", no podrá realizar cambios.<br />
            ¿Está usted seguro de realizar esta operación?
        </b>
    </p>
    <br />
</div>

<div align="center">
    <div class="col-md-11">
        <button type="reset" class="btn btn-primary redirect" data-target="#exampleModal">Regresar</button>
        <div class="col-md-1"></div>
        <input type="hidden" id="hi" />
        <button type="submit" class="btn btn-primary" data-target="#exampleModal" id="butonPago">Confirmar</button>
    </div>
</div>

<script type="text/javascript">
    $("#butonPago").click(function (e) {
        $("#butonPago").attr(\'disabled\', true);
        $("#preloader").show();
        
        if ($("#hi").attr("value") === "1") {
            e.preventDefault();
        } else {
            $("#hi").attr("value", "1");
            var url = \'/Menudeo/MenudeoCompra\';
            window.location.href = url;
        }
    });
    
    $(".redirect").click(function () {
        window.location = "../Menudeo/Index";
    });
</script>

        </div>
    </div>
</body>
</html>';
}

/**
 * Genera error de sesión inválida
 */
function generateSessionError() {
    return '
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" xml:lang="en" lang="en" translate="no" />
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Error</title>
    <link rel="stylesheet" href="../../Content/Site.min.css" type="text/css" />
    <link rel="stylesheet" href="../../Content/bootstrap.css?v=2.2.7.2" />
    
    <meta http-equiv="Expires" content="0">
    <meta http-equiv="Last-Modified" content="0">
    <meta http-equiv="Cache-Control" content="no-cache, mustrevalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta name="robots" content="noindex,nofollow" />
    
    <style>
        #myDIV { overflow: auto; }
    </style>
    
    <script type="text/javascript">
        function GoTopPage() {
            var elmnt = document.getElementById("TituloX");
            elmnt.scrollIntoView();
        }
    </script>
</head>
<body onload="GoTopPage()">
    <div id="body">
        <div class="container-fluid" id"mydiv">
            <div class="col-md-12" id="TituloX"></div>
            
<div class="col-md-12">
    <div class="panel panel-default ">
        <div class="panel-heading">
            <div class="ConDiv">
                <i class="icon-exclamacion"></i>
            </div>
        </div>
        <div class="panel-body">
            <p style="font-family: Helvetica" class="banesco_info_panel ">
                En este momento no podemos procesar la transacción que Ud. desea realizar. Por favor, intente más tarde.
            </p>
        </div>
    </div>
    <div class="col-md-offset-10">
        <p align="right">GEN</p>
    </div>
</div>

        </div>
    </div>
</body>
</html>';
}

/**
 * Genera error de menudeo cerrado
 */
function generateMenudeoClosed() {
    return '
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" xml:lang="en" lang="en" translate="no" />
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Menudeo No Disponible</title>
    <link rel="stylesheet" href="../../Content/Site.min.css" type="text/css" />
    <link rel="stylesheet" href="../../Content/bootstrap.css?v=2.2.7.2" />
    
    <meta http-equiv="Expires" content="0">
    <meta http-equiv="Last-Modified" content="0">
    <meta http-equiv="Cache-Control" content="no-cache, mustrevalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta name="robots" content="noindex,nofollow" />
    
    <style>
        #myDIV { overflow: auto; }
    </style>
    
    <script type="text/javascript">
        function GoTopPage() {
            var elmnt = document.getElementById("TituloX");
            elmnt.scrollIntoView();
        }
    </script>
</head>
<body onload="GoTopPage()">
    <div id="body">
        <div class="container-fluid" id"mydiv">
            <div class="col-md-12" id="TituloX"></div>
            
<div class="col-md-12">
    <div class="panel panel-default ">
        <div class="panel-heading">
            <div class="ConDiv">
                <i class="icon-exclamacion"></i>
            </div>
        </div>
        <div class="panel-body">
            <p style="font-family: Helvetica" class="banesco_info_panel ">
                El monto solicitado supera el disponible. Verifique la disponibilidad de divisas e intente nuevamente.
            </p>
        </div>
    </div>
    <div class="col-md-offset-10">
        <p align="right">MENUDEO_CLOSED</p>
    </div>
</div>

        </div>
    </div>
</body>
</html>';
}

/**
 * Genera respuesta de compra completada exitosamente
 */
function generateSuccessCompleted() {
    $timestamp = date('d/m/Y H:i:s');
    $referencia = 'REF' . date('YmdHis') . rand(1000, 9999);
    
    return '
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" xml:lang="en" lang="en" translate="no" />
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Operación Exitosa</title>
    <link rel="stylesheet" href="../../Content/Site.min.css" type="text/css" />
    <link rel="stylesheet" href="../../Content/bootstrap.css?v=2.2.7.2" />
    
    <meta http-equiv="Expires" content="0">
    <meta http-equiv="Last-Modified" content="0">
    <meta http-equiv="Cache-Control" content="no-cache, mustrevalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta name="robots" content="noindex,nofollow" />
    
    <style>
        #myDIV { overflow: auto; }
        .success-panel { background-color: #d4edda; border-color: #c3e6cb; }
        .success-text { color: #155724; }
    </style>
    
    <script type="text/javascript">
        function GoTopPage() {
            var elmnt = document.getElementById("TituloX");
            elmnt.scrollIntoView();
        }
    </script>
</head>
<body onload="GoTopPage()">
    <div id="body">
        <div class="container-fluid" id"mydiv">
            <div class="col-md-12" id="TituloX"></div>
            
<div class="col-md-12">
    <div class="panel panel-default success-panel">
        <div class="panel-heading">
            <div class="ConDiv">
                <i class="icon-check" style="color: #28a745;"></i>
            </div>
        </div>
        <div class="panel-body">
            <h3 class="success-text">¡Operación Exitosa!</h3>
            <p style="font-family: Helvetica" class="banesco_info_panel success-text">
                Su compra de divisas ha sido procesada exitosamente.
            </p>
            <br>
            <div class="row">
                <div class="col-md-6"><strong>Fecha y Hora:</strong></div>
                <div class="col-md-6">' . $timestamp . '</div>
            </div>
            <div class="row">
                <div class="col-md-6"><strong>Referencia:</strong></div>
                <div class="col-md-6">' . $referencia . '</div>
            </div>
            <div class="row">
                <div class="col-md-6"><strong>Monto:</strong></div>
                <div class="col-md-6">$ 100.00 USD</div>
            </div>
            <div class="row">
                <div class="col-md-6"><strong>Estado:</strong></div>
                <div class="col-md-6" style="color: #28a745;"><strong>COMPLETADA</strong></div>
            </div>
        </div>
    </div>
</div>

        </div>
    </div>
</body>
</html>';
}

/**
 * Genera error genérico
 */
function generateGenericError() {
    return '
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" xml:lang="en" lang="en" translate="no" />
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Error del Servidor</title>
    <link rel="stylesheet" href="../../Content/Site.min.css" type="text/css" />
    <link rel="stylesheet" href="../../Content/bootstrap.css?v=2.2.7.2" />
    
    <meta http-equiv="Expires" content="0">
    <meta http-equiv="Last-Modified" content="0">
    <meta http-equiv="Cache-Control" content="no-cache, mustrevalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta name="robots" content="noindex,nofollow" />
    
    <style>
        #myDIV { overflow: auto; }
    </style>
    
    <script type="text/javascript">
        function GoTopPage() {
            var elmnt = document.getElementById("TituloX");
            elmnt.scrollIntoView();
        }
    </script>
</head>
<body onload="GoTopPage()">
    <div id="body">
        <div class="container-fluid" id"mydiv">
            <div class="col-md-12" id="TituloX"></div>
            
<div class="col-md-12">
    <div class="panel panel-default ">
        <div class="panel-heading">
            <div class="ConDiv">
                <i class="icon-exclamacion"></i>
            </div>
        </div>
        <div class="panel-body">
            <p style="font-family: Helvetica" class="banesco_info_panel ">
                Ha ocurrido un error interno del servidor. Por favor, contacte al administrador del sistema.
            </p>
        </div>
    </div>
    <div class="col-md-offset-10">
        <p align="right">ERR_500</p>
    </div>
</div>

        </div>
    </div>
</body>
</html>';
}

// =============================================================================
// LÓGICA PRINCIPAL DEL SERVIDOR
// =============================================================================

/**
 * Simula delay de red si está habilitado
 */
function simulateNetworkDelay() {
    global $SIMULATE_DELAY;
    if ($SIMULATE_DELAY) {
        $delay = rand(1, 3); // 1-3 segundos
        sleep($delay);
    }
}

/**
 * Obtiene el tipo de respuesta a generar
 */
function getResponseType() {
    global $RESPONSE_TYPE, $RANDOM_RESPONSE;
    
    if ($RANDOM_RESPONSE) {
        $types = ['form_success', 'tasas_detected', 'error_session', 'error_menudeo_closed', 'error_generic', 'success_completed'];
        return $types[array_rand($types)];
    }
    
    return $RESPONSE_TYPE;
}

/**
 * Registra información de debug
 */
function logDebugInfo($message) {
    global $DEBUG_MODE;
    if ($DEBUG_MODE) {
        error_log("[BANESCO_SIMULATOR] " . date('Y-m-d H:i:s') . " - " . $message);
    }
}

/**
 * Agrega headers personalizados a la respuesta
 */
function addCustomHeaders() {
    global $CUSTOM_HEADERS;
    
    if (isset($CUSTOM_HEADERS) && is_array($CUSTOM_HEADERS)) {
        foreach ($CUSTOM_HEADERS as $header => $value) {
            header("$header: $value");
        }
    }
}

/**
 * Procesa la petición y genera la respuesta apropiada
 */
function processRequest() {
    $method = $_SERVER['REQUEST_METHOD'];
    $uri = $_SERVER['REQUEST_URI'];
    $responseType = getResponseType();
    
    logDebugInfo("Request: $method $uri - Response Type: $responseType");
    
    // Agregar headers personalizados
    addCustomHeaders();
    
    // Simular delay de red
    simulateNetworkDelay();
    
    // Generar respuesta según el tipo configurado
    switch ($responseType) {
        case 'form_success':
            logDebugInfo("Generating form success response");
            return generateMenudeoForm();
            
        case 'tasas_detected':
            logDebugInfo("Generating tasas confirmation response");
            return generateTasasConfirmation();
            
        case 'error_session':
            logDebugInfo("Generating session error response");
            http_response_code(200); // Banesco devuelve 200 incluso con errores
            return generateSessionError();
            
        case 'error_menudeo_closed':
            logDebugInfo("Generating menudeo closed error response");
            return generateMenudeoClosed();
            
        case 'error_generic':
            logDebugInfo("Generating generic error response");
            http_response_code(500);
            return generateGenericError();
            
        case 'success_completed':
            logDebugInfo("Generating success completed response");
            return generateSuccessCompleted();
            
        default:
            logDebugInfo("Unknown response type, defaulting to form success");
            return generateMenudeoForm();
    }
}

// =============================================================================
// EJECUCIÓN PRINCIPAL
// =============================================================================

// Mostrar información de configuración si está en modo debug
if ($DEBUG_MODE) {
    logDebugInfo("=== BANESCO SIMULATOR STARTED ===");
    logDebugInfo("Response Type: $RESPONSE_TYPE");
    logDebugInfo("Simulate Delay: " . ($SIMULATE_DELAY ? 'YES' : 'NO'));
    logDebugInfo("Random Response: " . ($RANDOM_RESPONSE ? 'YES' : 'NO'));
    logDebugInfo("Request Method: " . $_SERVER['REQUEST_METHOD']);
    logDebugInfo("Request URI: " . $_SERVER['REQUEST_URI']);
}

// Procesar la petición y enviar respuesta
echo processRequest();

// Log final
logDebugInfo("Response sent successfully");

?>