<?php
/**
 * CONFIGURACIÓN DEL SIMULADOR BANESCO
 * 
 * Este archivo permite cambiar fácilmente el comportamiento del simulador
 * sin necesidad de editar el código principal.
 * 
 * INSTRUCCIONES DE USO:
 * 1. Cambia el valor de $RESPONSE_TYPE para simular diferentes escenarios
 * 2. Guarda el archivo
 * 3. El simulador usará automáticamente la nueva configuración
 * 
 * Autor: Asistente AI
 * Fecha: 2025-01-16
 */

// =============================================================================
// CONFIGURACIÓN PRINCIPAL - EDITA AQUÍ
// =============================================================================

/**
 * TIPO DE RESPUESTA A SIMULAR
 * 
 * Opciones disponibles:
 * 
 * 'form_success'        - Formulario de menudeo exitoso (Paso 2)
 *                         Muestra el formulario para ingresar datos de compra
 *                         
 * 'tasas_detected'      - Página de confirmación de tasas (Paso 3) ⭐ RECOMENDADO
 *                         Muestra las tasas de cambio y confirmación de compra
 *                         
 * 'error_session'       - Error de sesión inválida
 *                         Simula cuando la sesión ha expirado
 *                         
 * 'error_menudeo_closed' - Menudeo cerrado/no disponible
 *                          Simula cuando el servicio no está disponible
 *                          
 * 'error_generic'       - Error genérico del servidor
 *                         Simula errores internos del servidor
 *                         
 * 'success_completed'   - Compra completada exitosamente
 *                         Muestra confirmación de operación exitosa
 */

// *** CAMBIA ESTE VALOR PARA SIMULAR DIFERENTES RESPUESTAS ***
$RESPONSE_TYPE = 'tasas_detected';

// =============================================================================
// CONFIGURACIONES ADICIONALES
// =============================================================================

/**
 * SIMULAR DELAY DE RED
 * true  = Simula delay de 1-3 segundos (más realista)
 * false = Respuesta inmediata
 */
$SIMULATE_DELAY = true;

/**
 * RESPUESTA ALEATORIA
 * true  = Ignora $RESPONSE_TYPE y elige una respuesta al azar
 * false = Usa el valor de $RESPONSE_TYPE
 */
$RANDOM_RESPONSE = false;

/**
 * MODO DEBUG
 * true  = Registra información detallada en el log de errores
 * false = Funcionamiento silencioso
 */
$DEBUG_MODE = true;

/**
 * CONFIGURACIÓN DE TASAS (solo para 'tasas_detected')
 * Personaliza los valores que aparecen en la página de confirmación
 */
$TASA_CONFIG = [
    'monto_usd' => 100.00,                    // Monto en dólares
    'tasa_min' => 130.00,                     // Tasa mínima
    'tasa_max' => 140.00,                     // Tasa máxima
    'comision_porcentaje' => 0.002,           // Comisión (0.2%)
    'cuenta_origen' => '0134-****-**-***1234567',
    'cuenta_destino' => 'Cuenta Verde Persona (USD)',
    'destino_fondos' => 'Capital de Trabajo',
    'descripcion' => 'COMPRA DIVISAS'
];

// =============================================================================
// ESCENARIOS PREDEFINIDOS
// =============================================================================

/**
 * ESCENARIOS RÁPIDOS
 * Descomenta una de estas líneas para usar configuraciones predefinidas:
 */

// ESCENARIO 1: Flujo normal exitoso
// $RESPONSE_TYPE = 'tasas_detected';
// $SIMULATE_DELAY = true;
// $RANDOM_RESPONSE = false;

// ESCENARIO 2: Errores de sesión
// $RESPONSE_TYPE = 'error_session';
// $SIMULATE_DELAY = true;
// $RANDOM_RESPONSE = false;

// ESCENARIO 3: Menudeo cerrado
// $RESPONSE_TYPE = 'error_menudeo_closed';
// $SIMULATE_DELAY = false;
// $RANDOM_RESPONSE = false;

// ESCENARIO 4: Respuestas aleatorias (para testing)
// $RESPONSE_TYPE = 'form_success'; // Ignorado cuando RANDOM_RESPONSE = true
// $SIMULATE_DELAY = true;
// $RANDOM_RESPONSE = true;

// ESCENARIO 5: Operación completada
// $RESPONSE_TYPE = 'success_completed';
// $SIMULATE_DELAY = false;
// $RANDOM_RESPONSE = false;

// =============================================================================
// CONFIGURACIÓN AVANZADA
// =============================================================================

/**
 * HEADERS PERSONALIZADOS
 * Agrega headers adicionales a las respuestas
 */
$CUSTOM_HEADERS = [
    'X-Banesco-Simulator' => 'v1.0',
    'X-Response-Type' => $RESPONSE_TYPE,
    'X-Timestamp' => date('Y-m-d H:i:s')
];

/**
 * CONFIGURACIÓN DE LOGS
 * Personaliza el formato y destino de los logs
 */
$LOG_CONFIG = [
    'enabled' => $DEBUG_MODE,
    'format' => '[BANESCO_SIM] %s - %s',
    'include_request_data' => true,
    'include_response_type' => true
];

// =============================================================================
// VALIDACIÓN DE CONFIGURACIÓN
// =============================================================================

$valid_response_types = [
    'form_success',
    'tasas_detected', 
    'error_session',
    'error_menudeo_closed',
    'error_generic',
    'success_completed'
];

if (!in_array($RESPONSE_TYPE, $valid_response_types)) {
    error_log("[BANESCO_SIMULATOR] ADVERTENCIA: Tipo de respuesta inválido '$RESPONSE_TYPE'. Usando 'form_success' por defecto.");
    $RESPONSE_TYPE = 'form_success';
}

// =============================================================================
// INFORMACIÓN DE CONFIGURACIÓN ACTUAL
// =============================================================================

if ($DEBUG_MODE) {
    error_log("[BANESCO_SIMULATOR] === CONFIGURACIÓN CARGADA ===");
    error_log("[BANESCO_SIMULATOR] Tipo de respuesta: $RESPONSE_TYPE");
    error_log("[BANESCO_SIMULATOR] Simular delay: " . ($SIMULATE_DELAY ? 'SÍ' : 'NO'));
    error_log("[BANESCO_SIMULATOR] Respuesta aleatoria: " . ($RANDOM_RESPONSE ? 'SÍ' : 'NO'));
    error_log("[BANESCO_SIMULATOR] Modo debug: " . ($DEBUG_MODE ? 'SÍ' : 'NO'));
    error_log("[BANESCO_SIMULATOR] ======================================");
}

?>