<?php
/**
 * SCRIPT DE PRUEBA DEL SIMULADOR BANESCO
 * 
 * Este script verifica que el simulador funcione correctamente
 * y muestra ejemplos de todas las respuestas disponibles.
 * 
 * Uso: php test_simulator.php
 * 
 * Autor: Asistente AI
 * Fecha: 2025-01-16
 */

echo "\n";
echo "🏦 PRUEBA DEL SIMULADOR BANESCO\n";
echo "================================\n\n";

// Verificar que los archivos existen
echo "📁 Verificando archivos...\n";

$files = [
    'banesco_simulator.php' => 'Servidor principal',
    'simulator_config.php' => 'Archivo de configuración'
];

foreach ($files as $file => $description) {
    if (file_exists($file)) {
        echo "   ✅ $file - $description\n";
    } else {
        echo "   ❌ $file - $description (NO ENCONTRADO)\n";
        exit(1);
    }
}

echo "\n";

// Cargar configuración
echo "⚙️  Cargando configuración...\n";
require_once 'simulator_config.php';

echo "   📋 Tipo de respuesta: $RESPONSE_TYPE\n";
echo "   ⏱️  Simular delay: " . ($SIMULATE_DELAY ? 'SÍ' : 'NO') . "\n";
echo "   🎲 Respuesta aleatoria: " . ($RANDOM_RESPONSE ? 'SÍ' : 'NO') . "\n";
echo "   🐛 Modo debug: " . ($DEBUG_MODE ? 'SÍ' : 'NO') . "\n";

echo "\n";

// Simular peticiones
echo "🧪 Probando respuestas del simulador...\n\n";

$response_types = [
    'form_success' => '📝 Formulario de menudeo exitoso (Paso 2)',
    'tasas_detected' => '💰 Página de confirmación de tasas (Paso 3)',
    'error_session' => '🚫 Error de sesión inválida',
    'error_menudeo_closed' => '🔒 Menudeo cerrado/no disponible',
    'error_generic' => '⚠️  Error genérico del servidor',
    'success_completed' => '✅ Compra completada exitosamente'
];

foreach ($response_types as $type => $description) {
    echo "$description\n";
    
    // Verificar que el tipo está configurado correctamente
    if ($type === $RESPONSE_TYPE) {
        echo "   ⭐ CONFIGURACIÓN ACTUAL\n";
    }
    
    // Verificar características esperadas de cada tipo
    switch ($type) {
        case 'form_success':
            echo "   📋 Genera formulario de menudeo con campos de entrada\n";
            echo "   🎯 Útil para: Probar Paso 2 del flujo\n";
            break;
            
        case 'tasas_detected':
            echo "   💰 Genera página de confirmación con tasas de cambio\n";
            echo "   🎯 Útil para: Activar efectos visuales del bot\n";
            echo "   ⚡ RECOMENDADO para testing de efectos\n";
            break;
            
        case 'error_session':
            echo "   🚫 Genera error de sesión inválida\n";
            echo "   🎯 Útil para: Probar manejo de errores de sesión\n";
            break;
            
        case 'error_menudeo_closed':
            echo "   🔒 Genera error de menudeo no disponible\n";
            echo "   🎯 Útil para: Probar detección de menudeo cerrado\n";
            break;
            
        case 'error_generic':
            echo "   ⚠️  Genera error genérico del servidor\n";
            echo "   🎯 Útil para: Probar manejo de errores generales\n";
            break;
            
        case 'success_completed':
            echo "   ✅ Genera confirmación de operación exitosa\n";
            echo "   🎯 Útil para: Probar flujo completo exitoso\n";
            break;
    }
    
    echo "   ✅ Tipo de respuesta válido\n";
    echo "\n";
}

// Verificar configuración de tasas
echo "💰 Verificando configuración de tasas...\n";

if (isset($TASA_CONFIG) && is_array($TASA_CONFIG)) {
    echo "   💵 Monto USD: $" . number_format($TASA_CONFIG['monto_usd'], 2) . "\n";
    echo "   📈 Tasa mínima: " . number_format($TASA_CONFIG['tasa_min'], 2) . "\n";
    echo "   📈 Tasa máxima: " . number_format($TASA_CONFIG['tasa_max'], 2) . "\n";
    echo "   💳 Comisión: " . ($TASA_CONFIG['comision_porcentaje'] * 100) . "%\n";
    echo "   🏦 Cuenta origen: " . $TASA_CONFIG['cuenta_origen'] . "\n";
    echo "   💚 Cuenta destino: " . $TASA_CONFIG['cuenta_destino'] . "\n";
    echo "   📝 Destino fondos: " . $TASA_CONFIG['destino_fondos'] . "\n";
    echo "   📄 Descripción: " . $TASA_CONFIG['descripcion'] . "\n";
    echo "   ✅ Configuración de tasas válida\n";
} else {
    echo "   ❌ Configuración de tasas no encontrada\n";
}

echo "\n";

// Instrucciones finales
echo "🚀 INSTRUCCIONES DE USO\n";
echo "======================\n\n";

echo "1. Para iniciar el simulador:\n";
echo "   php -S localhost:8080 banesco_simulator.php\n\n";

echo "2. Para cambiar el tipo de respuesta:\n";
echo "   Edita simulator_config.php y cambia \$RESPONSE_TYPE\n\n";

echo "3. Para probar con el bot:\n";
echo "   - Configura main_testserver.py para usar http://localhost:8080\n";
echo "   - Ejecuta: python main_testserver.py\n\n";

echo "4. Tipos de respuesta recomendados para testing:\n";
echo "   - 'tasas_detected' → Para probar efectos visuales\n";
echo "   - 'error_session' → Para probar manejo de errores\n";
echo "   - 'form_success' → Para probar flujo completo\n\n";

echo "✅ PRUEBA COMPLETADA - El simulador está listo para usar\n\n";

?>